model Ex2_5
parameter Real x1(unit="m")=0.23"thickness of fire brick layer";
parameter Real x2(unit="m")=0.115"thickness of insulating brick layer";   
parameter Real x3(unit="m")=0.23"thickness of building brick layer";
parameter Real T1(unit="K")=1213"Inside Temperature of furnace";  
parameter Real T2(unit="K")=318"Outside temperature of furnace";   
parameter Real k1(unit="W/(m.K)")=6.047"Thermal conductivity of fire brick";   
parameter Real k2(unit="W/(m.K)")=0.581"Thermal conductivity of insulating brick";   
parameter Real k3(unit="W/(m.K)")=2.33"Thermal conductivity of building brick";   
Real dT(unit="K")"Temperature difference";
Real Q_by_A(unit="J/s")"Heat lost per unit area";
Real Ta(unit="K")"Temperature at interface between fire brick and insulating break";
Real Tb(unit="K")"Temerature at interface between insulating brick and building brick";
equation
dT = T1-T2;  
Q_by_A = dT/((x1/k1)+(x2/k2)+(x3/k3)); 
dT/((x1/k1)+(x2/k2)+(x3/k3))= (T1-Ta)/(x1/k1);
dT/((x1/k1)+(x2/k2)+(x3/k3))= (Tb-T2)/(x3/k3);
//Ans is wrong in book
end Ex2_5;
