package Ex2_50
  model Ex2_50_I
  import Modelica.Math.*;
  parameter Real h_oil(unit = "W/sq m.K") = 180 "convective coeff on oil side";
  parameter Real h_air(unit = "W/sq m.K") = 15 "convective coeff on air side";
  parameter Real T_oil(unit = "K") = 353 "Temperature of oil";
  parameter Real T_air(unit = "K") = 293 "Temperature of air";
  parameter Real k(unit = "W/(m.K)") = 80 "Conductivity";
  parameter Real for_section(unit = "m") = 11 * 10 ^ (-3) "Base Area of wall ";
  parameter Real L(unit = "m") = 25 / 1000 "Length";
  parameter Real W(unit = "m") = 1 "Width,..let";
  parameter Real t(unit = "m") = 1 / 1000 "Thickness ";
  parameter Real N = 1 "Number of fins";
  Real delta_T(unit = "K") "Temperature difference";
  Real A(unit = "sq.m") "Area";
  Real P(unit = "m") "Perimeter";
  Real Af(unit = "sq.m") "Total fin surface Area";
  Real Ab(unit = "sq m") "Base Area";
  Real m "Constant";
  Real nf_oil "Efficiency";
  Real Ae_oil(unit = "sq m") "Net effective Area";
  Real Q(unit = "W") "Rate of heat transfer";
  equation
  delta_T = T_oil - T_air;
  A = W * t;
  P = 2 * (W + t);
  Af = 2 * L * W;
  Ab = for_section - A;
//CASE 1: Fin on oil side only
  m = sqrt(h_oil * P / (k * A));
  nf_oil = tanh(m * L) / (m * L);
  Ae_oil = Ab + nf_oil * Af * N;
  Q = delta_T / (1 / (h_oil * Ae_oil) + 1 / (h_air * for_section));
  end Ex2_50_I;






  model Ex2_50_II
  import Modelica.Math.*;
  parameter Real h_oil(unit = "W/sq m.K") = 180 "convective coeff on oil side";
  parameter Real h_air(unit = "W/sq m.K")=15"convective coeff on air side";
  parameter Real T_oil(unit = "K") = 353 "Temperature of oil";
  parameter Real T_air(unit = "K")=293"Temperature of air";
  parameter Real k(unit = "W/(m.K)")=80"Conductivity";
  parameter Real for_section(unit = "m")=11*10^(-3)"Base Area of wall ";
  parameter Real L(unit = "m")=25/1000"Length";
  parameter Real W(unit = "m")=1"Width,..let";
  parameter Real t(unit = "m")=1/1000"Thickness ";
  parameter Real N=1"Number of fins";
  Real delta_T(unit = "K")"Temperature difference";
  Real A(unit = "sq.m")"Area";
  Real P(unit = "m")"Perimeter";
  Real Af(unit="sq.m")"Total fin surface Area";
  Real Ab(unit = "sq m")"Base Area";
  Real m1"Constant";
  Real nf_air"Efficiency";
  Real Ae_air(unit = "sq m")"Net effective Area";
  Real Q(unit = "W")"Rate of heat transfer";
  equation
  delta_T=T_oil-T_air;    
  A=W*t;   
  P=2*(W+t);
  Af=2*L*W;    
  Ab=for_section-A;      
  //CASE 2: Fin on  air side only
  m1=sqrt(h_air*P/(k*A));
  nf_air=(tanh(m1*L))/(m1*L);
  Ae_air=Ab+nf_air*Af*N;    
  Q=delta_T/((1/(h_oil*for_section))+(1/(h_air*Ae_air)));    
  end Ex2_50_II;








end Ex2_50;
