model Ex2_8
parameter Real x1(unit="m")=0.02"Thickness of  Wood wall";  
parameter Real x2(unit="m")=0.01"Thickness of cork-board";  
parameter Real x3(unit="m")=0.02"Thickness of wood wall";  
parameter Real k1(unit="W/(m.k)")=0.105"Thermal conductivity of wood wall "; 
parameter Real A(unit="sq m")=1"Area of wall"; 
parameter Real k2(unit="W/(m.K)")=0.041"Thermal conductivity of cork-board";  
parameter Real Tx(unit="K")=293"Zone temperature";    
parameter Real T1(unit="K")=303"Temperature of inner wall surface";
parameter Real T2(unit="K")=263"Temperature of outer wall surface";
parameter Real Rx(unit="K/W")=0.9524"Resistance upto a distance x";
Real dT(unit="K")"Temperature difference";
Real k3(unit="W/(m.k)")"Thermal conductivity of wood wall";
Real Q_by_A(unit="W/m2")"Rate of heat loss";
Real x(unit="m")"Distance from outside of outer wooden wall and inside the wooden wall";
Real R(unit="K/W")"Total Resistance";  
equation
dT = T1-T2;  
k3=k1;
Q_by_A=dT/((x1/k1)+(x2/k2)+(x3/k3));
R=(x1/k1*A)+(x2/k2*A)+(x3/k3*A);
(T1-Tx)/dT=Rx*x/R;
//x value calculated in book is wrong.
end Ex2_8;
