model Ex3_12
import Modelica.Constants.*;
parameter Real v(unit="sq m/s")=18.23*10^(-6)"Kinematic viscocity";  
parameter Real k(unit="W/m.K")=0.02814"Thermal conductivity";   
parameter Real D(unit="m")=0.012"Diameter";    
parameter Real r(unit="m")=0.006"radius";    
parameter Real u_inf(unit="m/s")=4"viscosity"; 
parameter Real Tw(unit="K")=350"Temperature";  
parameter Real T_inf(unit="K")=300"Temperature";    
Real Nre"Reynold's no";
Real Nnu"Nusselt no";
Real h(unit="W/(sq.m.K)")"Average value of Convective heat transfer co-efficient";
Real A(unit="sq m")"Area of sphere";
Real Q(unit="W")"Rate of heat flow";
equation
Nre=D*u_inf/v;    
Nnu=0.37*Nre^(0.6);
h=Nnu*(k/D);    
A=4*pi*r^2;   
Q=h*A*(Tw-T_inf);    
end Ex3_12;
