package Ex3_16
  model Ex3_16_a
    import Modelica.Constants.*;
    parameter Real v(unit = "sq m/s") = 20.92 * 10 ^ (-6) "kinematic viscocity";
    parameter Real k(unit = "W/(m.K)") = 3 * 10 ^ (-2) "Thermal conbductivity";
    parameter Real Npr = 0.7 "Prandtl number";
    parameter Real u_inf(unit = "m/s") = 25 "velocity";
    parameter Real d(unit = "m") = 50 / 1000 "Diameter";
    parameter Real Tw(unit = "K") = 397 "surface Temperature of tube";
    parameter Real T_inf(unit = "K") = 303 "Temperature of Air";
    Real Nre "Reynold's no";
    Real Nnu "Nusselt no";
    Real h(unit = "W/s m.K") "Heat transfer coeffficient";
    Real Q(unit = "W") "heat transfer";
    Real Q_by_l(unit = "W") "Heat transfer per unit length";
  equation
    Nre = (u_inf * d) / v;
//Case 1: Circular tube
    Nnu = 0.0266 * Nre ^ 0.805 * Npr ^ (1.0 / 3.0);
    h = Nnu * k / d;
    Q = h * pi * d * (Tw - T_inf);
    Q_by_l = h * pi * d * (Tw - T_inf);
  // Value of Nre is wrong in book. 
  end Ex3_16_a;



  model Ex3_16_b
  import Modelica.Constants.*;
  parameter Real v(unit = "sq m/s")=20.92 * 10 ^ (-6) "kinematic viscocity";
  parameter Real k(unit = "W/(m.K)")=3 * 10 ^ (-2) "Thermal conbductivity";
  parameter Real Npr = 0.7 "Prandtl number";
  parameter Real u_inf(unit = "m/s")=25 "velocity";
  parameter Real d(unit = "m") = 50/1000 "Diameter";
  parameter Real Tw(unit = "K") = 397"surface Temperature of tube";
  parameter Real T_inf(unit = "K") =303"Temperature of Air";
  parameter Real A(unit="sq.mm")=50*50"Area";
  parameter Real P(unit="mm")=2*(50+50)"Perimeter";  
  Real Nre "Reynold's no";
  Real Nnu "Nusselt no";
  Real h(unit = "W/s m.K") "Heat transfer coeffficient";
  Real l(unit="m")"length";
  Real Q(unit = "W") "heat transfer";
  Real Q_by_l(unit = "W")"Heat loss per unit length";
  equation
  Nre=u_inf*d/v;    //Reynold's number
  //Case 2:Square tube
  l=(4*A/P)/1000;      
  Nnu=0.102*(Nre^0.675)*(Npr^(1.0/3.0));
  h=Nnu*k/d;   
  Q=h*(4*l*l)*(Tw-T_inf);
  Q_by_l=Q/l;   
  end Ex3_16_b;











end Ex3_16;
