model Ex3_23
import Modelica.Constants.*;
parameter Real vfr(unit = "l/h")=1200"Water flow rate";
parameter Real rho(unit = "Kg/l")=0.98"Density of water";
parameter Real Cp(unit = "J/kg.K")=4.187*10^3"Specific heat capacity";
parameter Real Di(unit = "m")=0.025"Diameter";
parameter Real mu(unit = "kg/(m.s)")=0.0006"Viscocity";
parameter Real k(unit = "W/(m.K)")=0.63"Thermal conductivity for water ";
parameter Real ho(unit = "W/sq m.K")=5800"Film heat coefficient";
parameter Real Do(unit = "m")=0.028"OD of tube";
parameter Real k1(unit = "W/(m.K)")=50"Thermal conductivity for metal wall";
parameter Real dT(unit = "K")=343-303"Temperature gradient";
parameter Real dT1(unit = "K")=393-303"Temperature gradient";
parameter Real dT2(unit = "K")=393-343"Temperature gradient";
parameter Real Cp1(unit = "[kJ/kg.K")=(4.187*10^3)/1000"Specific heat capacity";
Real m_dot(unit = "kg/h")"Mass flow rate of water";
Real m_dot2(unit = "kg/s")"Mass flow rate of water";
Real Ai(unit = "m^2")"Area of cross-section ";
Real Nre"Reynolds number";
Real Npr"Prandlt number";
Real Nnu"Nusselt number";
Real hi(unit = "W/(sq m.K)")"Heat transfer coeffcient";
Real xw(unit = "m")"Thickness";
Real Dw(unit = "m")"Logaritmic mean diamter";
Real Uo(unit = "W/sq m.K")"Overall heat transfer co-efficient";
Real dTm(unit = "K")"Log mean temperature";
Real Q(unit = "J/s")"Rate of heat transfer";
Real Ao(unit = "sq m")"Heat transfer area ";
Real L(unit = "m")"Length";
equation
m_dot=vfr*rho;    
m_dot2=m_dot/3600;    
Ai=(pi/4)*(Di)^2;    
Nre=(Di/mu)*(m_dot2/Ai);// Ans Varies due to rounding of values in book.   
Npr=Cp*mu/k;    
Nnu=0.023*(Nre^(0.8))*(Npr^(0.4));//// Ans Varies due to rounding of values in book.   
hi=Nnu*k/Di;    
xw=(Do-Di)/2;   
Dw=(Do-Di)/log(Do/Di);    
Uo=1/(1/ho+Do/(hi*Di)+xw*Do/(k1*Dw));    
dTm=(dT1-dT2)/log(dT1/dT2); 
Ao=Q/(Uo*dTm);   
Q=m_dot*Cp1*dT*1000/3600;    
//Also,..Ao=%pi*Do*L    ..implies that
L=Ao/(pi*Do);  
end Ex3_23;
