model Ex3_24
import Modelica.Math.*;
parameter Real T(unit = "K")=360"Temperature of cooling coil";
parameter Real T1(unit = "K")=280"inlet Temperature";
parameter Real T2(unit = "K")=320"inlet Temperature";
parameter Real Cp1(unit = "J/kg.K")=4.187"Heat capacity ";
Real dT1(unit = "K")"Temperature gradient";
Real dT2(unit = "K")"Temperature gradient";
Real dTlm(unit = "K")"Log mean temperature";
Real m1_by_UA;
Real t(unit="K")"Outer Temperature";
equation
dT1=T-T1;       
dT2=T-T2;       
//Q1=m1_dot*Cp1*(T2-T1)
dTlm=(dT1-dT2)/log(dT1/dT2); 
m1_by_UA=dTlm/(Cp1*(T2-T1));
//For final conditions :
//m2_dot=m1_dot
//U2=U1
//A2=5*A1 
((m1_by_UA*Cp1)/5)=1/log(dT1/(T-t));
end Ex3_24;
