model Ex3_33
import Modelica.Constants.*;
parameter Real k(unit = "W/m.K")=0.03406"Thermal conductivity";
parameter Real Beta(unit="K^-1")=2.47*10^(-3)"Volume expansion coefficient";
parameter Real Npr=0.687"Prandtl number";
parameter Real v(unit="m^2/s")=26.54*10^(-6)"Viscocity ";
parameter Real g(unit = "m/s^2")=9.81"Acceleration due to gravity";
parameter Real Tw(unit = "K")=523"Temperature of pipe";
parameter Real T_inf(unit = "K")=288"Temperature of air";
parameter Real D(unit = "m")=0.3048"Diameter";
Real dT(unit = "K")"Temperature gradient";
Real Ngr"Grashof number";
Real Nra"rayleigh number";
Real Nnu"Nusselt number";
Real h(unit = "W/sq m.K")"Average heat transfer coefficient";
Real Q_by_l(unit = "W/m")"Heat loss per metre length ";
equation
dT=Tw-T_inf;
Ngr=(g*Beta*dT*(D^3))/(v^2);     
Nra=Ngr*Npr; 
//For Nra less than 10^9,we have for horizontal cylinder
Nnu=0.53*(Nra^(1.0/4.0));    
h=Nnu*k/D;  
Q_by_l=h*pi*D*dT; 
//Ans in book varies due to slight approximation
end Ex3_33;
