model Ex3_4
parameter Real mu(unit="kg/(m.s)")=1.85*10^(-5)"viscosity";          
parameter Real P(unit="kPa")=101.325"Pressure";               
parameter Real M_avg(unit="kg/mol")=29"Avg molecular wt of air";               
parameter Real R(unit="J/(kg·K)")=8.31451"Gas constant";              
parameter Real T(unit="K")=300"Temperature";                   
parameter Real u_inf(unit="m/s")=2"viscosity";            
parameter Real x(unit="m")=0.2"distance";                   
parameter Real x2(unit="m")=0.4"distance";         
Real rho(unit="kg/m^3")"Density of air";
Real Nre_x"Reynold number";
Real del(unit = "m")"Boundary layer thickness";
Real Nre_x2"Reynold number";
Real del1(unit = "m")"Boundary layer thickness";
Real delta_m_dot(unit = "kg/s")"Mass Flow entering the boundary layer";
equation
rho=P*M_avg/(R*T); 
//At x=20 cm =0.2 m
Nre_x=rho*u_inf*x/mu;        
del=4.64/sqrt(Nre_x)*x;                           
//At x2=0.4
Nre_x2=(rho*u_inf*x2)/mu;    
//Boundary layer is laminar 
del1=4.64/sqrt(Nre_x2)*x2;                                                 
//By integrating Eq1
delta_m_dot=0.625*u_inf*rho*(del1-del);           
end Ex3_4;
