model Ex3_41
parameter Real rho(unit = "kg/m^3")=0.910"Density ";
parameter Real Cp(unit = "J/kg.K")=1.009*1000"Specific Heat capacity";
parameter Real k(unit = "W/m.K")=0.0331"Thermal conductivity";
parameter Real mu(unit = "N.s/m^2")=22.65*10^(-6)"[viscocity";
parameter Real a(unit = "m")=0.03"length";
parameter Real b(unit = "m")=0.05"breadth";
parameter Real Tf(unit = "K")=388"Film temperature";
parameter Real T1(unit = "K")=303"Temperature of still air ";
parameter Real T2(unit = "K")=473"Temperature of plate";
parameter Real g(unit = "m/s^2")=9.81"Acceleration due to  gravity";
Real A(unit = "sq m")"Area ";
Real Beta(unit = "K^-1")"Volume expansion coefficient";
Real dT(unit = "K")"Temperature gradient";
Real v(unit = "m^2/s")"Kinematic viscocity";
Real hb(unit = "W/sq m.K")"Convective heat transfer coefficient";
Real Qb(unit = "W")"Heat transfer";
Real Qa(unit = "W")"Heat transfer";
equation
//Let a=smaller side
//b=bigger side
A=a*b;           
Beta=1/Tf;       
dT=T2-T1;        
v=mu/rho;        
hb=0.59*(((g*Beta*dT*(b^3))/(v^2))*Cp*mu/k)^(1/4)*(k/b);      
Qb=hb*A*(dT);            
Qa=1.14*Qb;              
end Ex3_41;
