model Ex3_42
import Modelica.Constants.*;
parameter Real Ts(unit = "K")=373"Saturation temperature";
parameter Real rho_l(unit = "kg/m^3")=957.9"Density of saturated liquid";
parameter Real Cpl(unit = "J/kg.K")=4217"Specific Heat capacity";
parameter Real mu_l(unit = "kg/(m.s)")=27.9*10^(-5)"viscocity";
parameter Real rho_v(unit = "kg/m^3")=0.5955"Density of saturated vapour";
parameter Real Csf=0.013"constant";
parameter Real sigma(unit = "N/m")=5.89*10^(-2)"Surface tension of liquid-vapor interface";
parameter Real Nprl(unit="m")=1.76"Prandlt number";
parameter Real lambda(unit = "J/kg")=2257*1000"Latent heat-enthaply of vaporisation";
parameter Real n=1;
parameter Real m_dot(unit = "kg/s")=30/3600"Mass flow rate ";
parameter Real D(unit = "m")=30/100"Diameter of pan ";
parameter Real g(unit = "m/s^2")=9.81"Acceleration due to  gravity";
Real A(unit = "sq m")"Area ";
Real Q_by_A(unit = "W/sq m")"Surface heat flux";
Real dT(unit = "K")"Temperature gradient";
Real Tw(unit = "K")"Surface temperature";
equation
A=pi*(D/2)^2; 
Q_by_A=m_dot*lambda/A;   
//For nucleate boiling point we have:
dT=(lambda/Cpl)*Csf*(((Q_by_A)/(mu_l*lambda))*sqrt(sigma/(g*(rho_l-rho_v))))^(1.0/3.0)*(Nprl^n);
Tw=Ts+dT;   
end Ex3_42;
