model Ex3_45
import Modelica.Constants.*;
parameter Real dT(unit = "K")=10"Temperature gradient";
parameter Real P(unit = "Mpa")=506.625/10^3"Pressure";
parameter Real D(unit = "m")=25.4/1000"Diameter";
Real h(unit = "W/sq m.K")"Convective heat transfer coeff";
Real Q_by_l(unit = "W/m")"Heat transfer rate per unit length ";
equation
h=2.54*(dT^3)*(e^(P/1.551));   //[W/sq m.K]
//Q=h*%pi*D*L*dT
//Heat transfer rate per meter length of tube is 
Q_by_l=h*pi*D*dT;   
//Ans varies due to approximation in book
end Ex3_45;
