model Ex3_47
import Modelica.Constants.*;
parameter Real mu(unit = "N.s/m^2")=306*10^(-6)"viscocity";
parameter Real k(unit = "W/m.K")=0.668"thermal conductivity";
parameter Real rho(unit = "kg/m^3")=974"Density";
parameter Real lambda(unit = "J/kg.K")=2225*10^3"Latent heat-enthaply of vaporisation";
parameter Real g(unit = "m/s^2")=9.81"Acceleration due to  gravity";
parameter Real Ts(unit = "K")=373"Temperature of steam ";
parameter Real Tw(unit = "K")=357"Temperature of pipe";
parameter Real Do(unit = "m")=25/1000"OD";
Real dT(unit = "K")"Temperature gradient";
Real h(unit = "W/sq m.K")"Convective heat transfer coeff";
Real Q_by_l(unit = "W/m")"Heat transfer per unit length";
Real m_dot_byl(unit = "kg/h")"mass flowrate of condensate per unit length";
equation
dT=Ts-Tw;    
h=0.725*((rho^2*g*lambda*k^3)/(mu*Do*dT))^(1.0/4.0); 
Q_by_l=h*pi*Do*dT;  
m_dot_byl=(Q_by_l/lambda)*3600;   
end Ex3_47;
