model Ex3_5
parameter Real mu(unit="sq.m/s")=3.9*10^(-4)"Kinematic viscosity";
parameter Real k(unit="W/(m.K)")=36.4*10^(-3)"Thermal conductivity";   
parameter Real Npr=0.69"Prandlt number";
parameter Real u_inf(unit="m/s")=8"viscosity";
parameter Real L(unit="m")=1"Length of plate";
parameter Real T_inf(unit="K")=523"Temperature of air";    
parameter Real Tw(unit="K")=351"Temperature of plate ";    
parameter Real W(unit="m")=0.3"Width of plate";
Real Nre_l"Reynold number";
Real Nnu"Nusselt no.";
Real h(unit="W/sq.m.K")"Convective heat transfer co-efficient";
Real A(unit="sq.m")"Area of plate";
Real Q(unit="W")"Rate of heat removal";
Real Q1(unit="W")"Rate of heat removal from both sides of plate ";
equation
Nre_l=u_inf*L/mu; 
Nnu=0.664*sqrt(Nre_l)*Npr^(1.0/3.0);    
h=k*Nnu/L;    
A=W*L;   
Q=h*A*(T_inf-Tw);   
Q1=2*Q;   
end Ex3_5;
