model Ex3_8
parameter Real rho(unit="kg/cubic m")=0.998"Density";
parameter Real v(unit="sq m/s")=20.76*10^(-6)"kinematic viscocity";   
parameter Real k(unit="W/m.K")=0.03"Thermal conductivity";    
parameter Real Npr=0.697"prandlt number";
parameter Real x(unit="m")=0.4"length";    
parameter Real u_inf(unit="m/s")=3"viscosity";   
parameter Real Q(unit="w")=1450"Rate of heat transfer";
parameter Real Tw(unit="K")=407"Temperature";    
parameter Real T_inf(unit="K")=293"Temperature";
parameter Real L(unit="m")=0.4"Length";    
Real Nre_x"Reynold number";
Real Nnu_x"Nusselt number";
Real hx(unit="W/(sq.m.K)")"Convective heat transfer co-efficient";
Real h(unit="W/(sq.m.K)")"Average value of Convective heat transfer co-efficient";
Real w(unit = "m")"Width of the plate";
equation
Nre_x=u_inf*x/v;    //Reynold numebr at x=0.40 m
Nnu_x=0.332*sqrt(Nre_x)*(Npr^(1.0/3.0));
hx=Nnu_x*k/x;    
//Average heat tarnsfer coefficient is twice this value
h=2*hx;    
w=Q/(h*L*(Tw-T_inf));    
end Ex3_8;
