model Ex4_14
parameter Real sigma(unit = "W/(m^2.K^4)")=5.67*10^(-8)"stefan Boltzman Constant";
parameter Real e1=0.3"Emissivity of first wall ";
parameter Real e2=0.7"Emissivity of second wall";
parameter Real e3=0.05"Emissivity ofradiation shield";
Real Q_by_a(unit = "W/sq m")"Heat transfer without shield";
Real Q1_by_a(unit = "W/sq m")"Heat transfer with shield";
Real red(unit = "%")"Reduction in heat transfer";
equation
Q_by_a=1/((1/e1)+(1/e2)-1);   
Q1_by_a=1.093/(((1/e1)+(1/e3)-1)*2.093);
red=(Q_by_a-Q1_by_a)*100/Q_by_a;
end Ex4_14;
