model Ex4_17
import Modelica.Constants.*;
parameter Real sigma(unit = "W/(sq m.K^4)")=5.67*10^(-8)"stefan Boltzman Constant";
parameter Real e=0.8"Emissivity";
parameter Real T1(unit = "K")=673"Pipe surface temperature";
parameter Real T2(unit = "K")=303"Air temperature";
parameter Real Do(unit = "m")=200/1000"OD of pipe";
parameter Real L(unit = "m")=1"length of pipe";
parameter Real e1=0.8"Emissivity";
parameter Real e2=0.91"Emissivity";
parameter Real D1(unit = "m")=0.2"Diameter";
parameter Real D2(unit = "m")=0.4"Diameter of brick conduit";
Real A1(unit = "m^2/m")"Area";
Real Q1(unit = "W/m")"loss of heat";
Real Q2(unit = "W/m")"loss of heat";
Real Red(unit = "W/m")"Reduction in heat loss";
equation
A1=pi*Do*L; //[m^2/m]
//CAse 1: Pipe to surrundings
Q1=e*A1*sigma*(T1^4-T2^4);   
//CAse 1:  Concentric cylinders
Q2=sigma*0.628*(T1^4-T2^4)/((1/e1)+(D1/D2)*((1/e2)-1));
Red=Q1-Q2;  
//Ans varies due to approximation in book for value of Q1
end Ex4_17;
