model Ex5_1
import Modelica.Constants.*;
parameter Real Di(unit = "m")=35/1000"Inner Diameter";
parameter Real Do(unit = "m")=42/1000"outer Diameter";
//for benzene
parameter Real mb_dot(unit = "kg/h")=4450"mass flow rate ";
parameter Real Cpb(unit = "kJ/(kg.K)")=1.779"Specific heat capacity";
parameter Real t2(unit = "K")=322"Outlet temperature";
parameter Real t1(unit = "K")=300"Inlet temperature";
//For toulene
parameter Real T1(unit = "K")=344"Inlet temperature";
parameter Real T2(unit = "K")=311"Outlet temperature";
parameter Real Cpt(unit = "kJ/kg.K")=1.842"Specific heat capacity";
//Hot fluid(toluene)
//Cold fluid(benzene)
parameter Real dT1(unit = "K")=22"Temperature gradient";
parameter Real dT2(unit = "K")=11"Temperature gradient";
//Coldd fluid:Inner pipe,benzene
parameter Real mub(unit = "kg/(m.s)")=4.09*10^(-4)"viscocity";
parameter Real k(unit = "W/m.K")=0.147"Thermal conductivity";
parameter Real D1(unit = "m")=0.042"Outside dia of inside pipe";
parameter Real D2(unit = "m")=0.0525"Inside dia of outside pipe";
parameter Real mut(unit = "kg/(m.s)")=5.01*10^(-4)"viscocity";
parameter Real Rdi(unit = "m^2.K/W")=1.6*10^(-4)"Fouling factor ";
parameter Real Rdo(unit = "m^2.K/W")=1.6*10^(-4)"Fouling factor";
parameter Real ex(unit = "sq m")=0.136"Area";
Real Q(unit = "kJ/h")"Mass flow rate";
Real mt_dot(unit = "kg/h")"mass flow arte of touene";
Real dTlm(unit = "K")"Log mean temperature difference ";
Real Ai(unit = "sq m")"Flow area";
Real Gi(unit = "kg/m^2.s")"Mass velocity ";
Real Nreb"Reynolds number";
Real Cp(unit = "J/(kg.K)")"Specific heat capacity";
Real Nprb"Prandtl number";
Real hi(unit = "W/sq m.K")"Convective heat transfer coefficient";
Real hio(unit = "W/sq m.K")"Convective heat transfer coefficient";
Real De(unit = "m")"shell equivalent diameter";
Real aa(unit = "sq m")"Flow area";
Real Ga(unit = "kg/m^2.s")"Mass velocity ";
Real Nret"Reynolds number";
Real Nprt"Prandtl number";
Real ho(unit = "W/sq m.K")"Convective heat transfer coefficient";
Real Uc(unit = "W/sq m.K")"Overall clean heat transfer coefficient";
Real Rd(unit="m^2.K/W")"dirt factor";
Real Ud(unit = "W/sq m.K")"Overall dirt heat transfer coefficient";
Real A(unit="sq m")"Area";
Real l(unit="m")"Length";
Real tl(unit = "m")"Total length of one harpin of 6m ";
equation
Q=mb_dot*Cpb*(t2-t1);        
mt_dot=Q/(Cpt*(T1-T2));      
dTlm=(dT1-dT2)/(log(dT1/dT2));      
Ai=(pi/4)*Di^2;     
Gi=(mb_dot/Ai)/3600;        
Nreb=Di*Gi/mub;       
Cp=Cpb*10^3;         
Nprb=Cp*mub/k;        
hi=(k/Di)*0.023*(Nreb^0.8)*(Nprb^0.4);    
hio=hi*Di/Do;           
De=(D2^2-D1^2)/D1;           
aa=pi*(D2^2-D1^2)/4;          
Ga=(mt_dot/aa)/3600;        
Nret=De*Ga/mut;        
Nprt=Cp*mut/k;    
ho=(k/De)*0.023*(Nret^0.8)*(Nprt^0.3);     
Uc=1/(1/ho+1/hio);       
Rd=Rdi+Rdo;              
Ud=1/(1/Uc+Rd);         
A=(Q*1000/3600)/(Ud*dTlm);           
l=A/ex;                 
tl=12;       //Total length of one harpin of 6m [m]
//Answer in book differ due to approximation in book
end Ex5_1;
