model Ex5_13
import Modelica.Constants.*;
parameter Real mh_dot(unit = "kg/s")=1.25"Mass flowrate of hydrocarbon vapor";
parameter Real Cpw(unit = "J/kg.K")=4.187*10^3"Heat capacity of water  ";
parameter Real lambda(unit = "kJ/kg")=315"Latent heat of vaporisation of steam ";
parameter Real Ts(unit = "K")=345"Temperature of condensing vapour";
parameter Real t1(unit = "K")=290"Inlet temperature of water ";
parameter Real t2(unit = "K")=310"Outlet temperature of water";
parameter Real hi(unit = "W/sq m.K")=2.5*1000"inside heat transfer coefficient";
parameter Real Do(unit = "m")=0.025"OD of tube";
parameter Real Di(unit = "m")=0.020"ID of tube";
parameter Real ho(unit = "W/sq m.K")=0.8*1000"Outside heat tranbsfer coefficient ";
parameter Real L(unit = "m")=1"Length";
parameter Real rho(unit = "kg/m^3")=1000"Density";
parameter Real v(unit = "m/s")=0.6"Velocity";
Real Q(unit = "W")"Rate of heat transfer from vapour";
Real dT1(unit = "K")"Temperature gradient ";
Real dT2(unit = "K")"Temperature gradient ";
Real dTlm(unit = "K")"Log mean temperature differnce";
Real mw_dot(unit = "kg/s")"Mass flowrate of water";
Real hio(unit = "W/sq m.K")"Inside heat transfer cosfficient referred to outside dia ";
Real Uo(unit = "W/sq m.K")"Overall heat transfer coefficient";
Real Ud(unit = "W/sq m.K")"Overall dirt heat transfer coefficient";
Real Ao(unit = "sq m")"Area";
Real A(unit="m2/m")"Outside area of pipe per m length of pipe";
Real len(unit="m")"Total length of piping required.";
Real V(unit = "m^3/s")"Volumetric flowrate";
Real a(unit = "sq m")"Cross-sectional area for flow pass ";
Real a1(unit = "sq m")"Cross-sectional area of single tube ";
Real n(unit="m")"No. of tubes per pass";
Real l(unit = "m")"Length of each tube";
Real tn"Total no of tubes";
Real l2(unit = "m")"Length of each tube";
Real tn2"Total no of tubes";
Real l3(unit = "m")"Length of each tube";
equation
Q=mh_dot*lambda*10^3;     
dT1=Ts-t1;         
dT2=Ts-t2;           
dTlm=(dT1-dT2)/log(dT1/dT2);         
//Heat removed from vapour = Heat gained
mw_dot=Q/(Cpw*(t2-t1));     
hio=hi*(Di/Do);              
Uo=1/(1/ho+1/hio);           
//Ud is 80% of Uc
Ud=(80/100)*Uo;            
Ao=Q/(Ud*dTlm);              
A=pi*Do*L;                  
len=Ao/A;                   
V=mw_dot/rho;               
a=V/v;                      
a1=(pi*Di^2)/4;             
//for single pass on tube side fluid(water)
n=a/a1;                     
l=len/n;                     
//For two passes on water side:
tn=2*n;                     
l2=len/tn;                  
//For four passes on water side/tube side
tn2=4*n;                     
l3=len/tn2;                  
end Ex5_13;
