model Ex5_23
import Modelica.Constants.*;
parameter Real Cpo(unit = "J/kg.K")=2131"Sp heat of oil  ";
parameter Real Cpw(unit = "J/kg.K")=4187"Sp heat of water ";
parameter Real mo_dot(unit = "kg/s")=0.10"Oil flow rate ";
parameter Real mw_dot(unit = "kg/s")=0.20"Water flow rate ";
parameter Real U(unit = "W/sq m.K")=380"Overall heat transfer coeff";
parameter Real T1(unit = "K")=373"Initial temp of oil ";
parameter Real T2(unit = "K")=333"Final temperature of oil ";
parameter Real t1(unit = "K")=303"Water enter temperature ";
parameter Real Do(unit = "m")=0.025"Inner tube diameter ";
Real t2(unit = "K")"Water outlet temperature";
Real dT1(unit="K")"Temperature gradient";
Real dT2(unit="K")"Temperature gradient";
Real dTlm(unit="K")"Log mean temperature differnece";
Real lmtd(unit="K")"Log mean temperature differnece";
Real Q(unit = "J/s")"Rate of heat transfer";
Real A(unit = "sq m")"Area";
Real L(unit = "m")"Length";
Real mCp_h(unit = "J/s.K")"Heat capacity rate For hot fluid ";
Real mCp_c(unit = "J/s.K")"Heat capacity rate For cold fluid ";
Real C"Capacity ratio";
Real E"Effeciency";
Real A1(unit = "sq m")"Area";
Real L1(unit = "m")"Length ";
Real ntu "Number of transfer units";
equation
t2=t1+mo_dot*Cpo*(T1-T2)/(mw_dot*Cpw);   
//1.LMTD method
dT1=T1-t2;           
dT2=T2-t1;           
dTlm=(dT1-dT2)/log(dT1/dT2);     
lmtd=dTlm;           
Q=mo_dot*Cpo*(T1-T2);        
A=Q/(U*dTlm);                
L=A/(pi*Do);               
//2.NTU method
mCp_c=mw_dot*Cpw;               
mCp_h=mo_dot*Cpo;              
//mCp_h=231.1;                
//mCp_h is smaller
C=mCp_h/mCp_c;
E=(T1-T2)/(T1-t1);               
//For countercurrent flow
E=(1-e^(-(1-C)*ntu))/(1-C*e^(-(1-C)*ntu));
A1=ntu*mCp_h/U;       
L1=A1/(pi*Do);        
//Calculation mistake in book. cp of oil is taken as 2311 in solution.
end Ex5_23;
