model Ex5_5
import Modelica.Constants.*;
parameter Real Cpc(unit = "J/(kg.K)")=4187"Specific heat of water" ;
parameter Real Cph(unit = "J/(kg.K)")=2000"Sp heat of oil ";
parameter Real mc_dot(unit = "kg/s")=1300/3600"mass flowrate of cold fluid ";
parameter Real mh_dot(unit = "kg/s")=550/3600"mass flowrate of hot fluid";
parameter Real U(unit = "W/sq m.K")=1075"Ooverall heat transfer coefficient";
parameter Real A(unit = "sq m")=1"Area";
parameter Real T1(unit = "K")=367"Inlet  temperature of Hot fluid";
parameter Real t1(unit = "K")=288"inlet Temperature of cold  fluid ";
Real w(unit = "W/K")"Heat capacity rate of cold fluid";
Real o(unit = "W/K")"Heat capacity rate of hot fluid";
Real ntu"Number of transfer units";
Real C"Capacity ratio";
Real E"Effeciency";
Real T2(unit = "K")"Outlet temperature of Hot fluid ";
Real t2(unit = "K")"outlet Temperature of cold  fluid ";
Real Q(unit = "W")"Rate of heat transfer";
equation
w=mc_dot*Cpc;        
o=mh_dot*Cph;        
ntu=(U*A)/(mh_dot*Cph);    
C=mh_dot*Cph/(mc_dot*Cpc);   
E=(1-e^(-ntu*(1-C)))/(1-C*e^(-ntu*(1-C)));    
T2=T1-E*(T1-t1);                 
t2=C*(T1-T2)+t1;                 
Q=mh_dot*Cph*(T1-T2);           
//Ans in book varies due to approximation
end Ex5_5;
