model Ex5_8
import Modelica.Constants.*;
parameter Real mdot(unit = "kg/h")=7250"Mass flowrate of Nitrobenzene" ;
parameter Real Cp(unit = "kJ/(kg.K)")=2.387"Specific heat capacity ";
parameter Real mu(unit = "kg/m.s")=7*10^(-4)"Viscocity";
parameter Real k(unit = "W/m.K")=0.151"Thermal conductivity";
parameter Real T1(unit = "K")=400"Inlet Temperature of Nitrobenzene ";
parameter Real T2(unit = "K")=317"Outlet Temperature of Nitrobenzene";
parameter Real t1(unit = "K")=305"Inlet Temperature of benzene";
parameter Real t2(unit = "K")=345"Outlett Temperature of benzene";
parameter Real n=166"no of tubes";
parameter Real L(unit = "m")=5"Length";
parameter Real Do(unit = "m")=0.019"Outer Dia.";
parameter Real Di(unit = "m")=0.015"Inner Dia.";
parameter Real Pt(unit = "m")=0.025"Pitch";
parameter Real B(unit = "m")=0.15"baffle spacing";
parameter Real id(unit = "m")=0.45"Inner Dia.";
parameter Real hi(unit = "W/sq m .K")=1050"Heat transfer coefficient";
Real dT1(unit = "K")"Temperature gradient ";
Real dT2(unit = "K")"Temperature gradient ";
Real dTlm(unit = "K")"Log mean temperature differnce";
Real Q(unit = "W")"Rate of heat transfer";
Real Ao(unit = "sq m")"Area";
Real Uo(unit = "W/sq m.K")"Overall heat transfer coefficient";
Real Ud(unit = "W/sq m.K")"Overall dirt heat transfer coefficient";
Real C_dash(unit = " m")"clearance";
Real as(unit = "sq m")"Shell side cross flow area";
Real as_dash(unit = "sq m")"Shell side area per pass";
Real De(unit = "m")"shell equivalent diameter";
Real Gs(unit = "kg/m^2.s")"Mass velocity";
Real Cp1(unit="m")"Specific heat capacity";
Real Nre"Reynolds number";
Real Npr"Prandtl number";
Real Nnu"Nusselt number";
Real ho(unit = "W/sq m.K")"Convective heat transfer coeficient";
Real Uo1(unit = "W/sq m K")"Overall heat transfer coefficient";
Real Uc(unit = "W/sq m.K")"Overall clean heat transfer coefficient";
Real Rd(unit="m^2.K/W")"dirt factor";
equation
dT1=T1-t2;              
dT2=T2-t1;              
dTlm=(dT1-dT2)/log(dT1/dT2);     
Q=mdot*Cp*(T1-T2)*1000/3600;   
Ao=n*pi*Do*L;           
Uo=Q/(Ao*dTlm);          
Ud=Uo;
//Shell side heat transfer coefficient
C_dash=Pt-(0.5*Do+0.5*Do);
//Shell side crossflow area
as=id*C_dash*B/Pt;       
//As there are two shell passes,area per pass is :
as_dash=as/2;           
//Equivalent diameter of shell 
De=4*(Pt^2-(pi/4)*Do^2)/(pi*Do);       
//Mass velocity on shell side
Gs=(mdot/as_dash)/3600;        
Cp1=Cp*1000;              
Nre=De*Gs/mu;    //Reynold number
Npr=Cp1*mu/k;     //Prandtls number
Nnu=0.36*Nre^0.55*Npr^(1.0/3.0);
ho=Nnu*k/De;        
Uo1=1/(1/ho+(1/hi*(Do/Di)));         
Uc=Uo1;
Rd=(Uc-Ud)/(Uc*Ud);                  
end Ex5_8;
