model Ex6_12
parameter Real Tf(unit = "K")=353"Feed temperature";
parameter Real T(unit = "K")=273"Sorrunding Temperature";
parameter Real mf_dot(unit = "kg/h")=10000"Feed ";
parameter Real ic=0.07"Initial conc of glycerine ";
parameter Real fc=0.4"FinaL CONC OF GLYCERINE";
parameter Real P(unit = "kPa")=313"Steam pressure";
parameter Real Ts(unit = "K")=408"Steam Temperature";
parameter Real P1(unit = "Kpa")=15.74"Pressure in last effect";
parameter Real Tv3(unit = "K")=328"Vapour temperature";
parameter Real bpr1(unit = "K")=10"Boiling point Rise";
parameter Real dT1(unit = "K")=14.5"Temperature gradient";
parameter Real dT2(unit = "K")=16"Temperature gradient";
parameter Real dT3(unit = "K")=19.5"Temperature gradient";
parameter Real Cpf(unit = "kJ/(kg.K)")=3.768"Specific Heat capacity";
parameter Real lambda_s(unit = "kJ/kg")=2160"Latent heat of condensation of steam ";
parameter Real Hv1(unit = "kJ/kg")=2692"enthalpy of vapour";
parameter Real lambda_v1(unit = "kJ/kg")=2228.3"latent heat of vaporization";
parameter Real Hv2(unit = "kJ/kg")=2650.8"enthalpy of vapour";
parameter Real lambda_v2(unit = "kJ/kg")=2297.4"latent heat of vaporization";
parameter Real Hv3(unit = "kJ/kg")=2600.5"enthalpy of vapour";
parameter Real lambda_v3(unit = "kJ/kg")=2370"latent heat of vaporization";
parameter Real U1(unit = "W/sq m.K")=710"Overall Heat transfer coefficient";
parameter Real U2(unit = "W/sq m.K")=490"Overall Heat transfer coefficient";
parameter Real U3(unit = "W/sq m.K")=454"Overall Heat transfer coefficient";
parameter Real dT_W=25"Rise in water temperature";
parameter Real Cp(unit="kJ/(kg.K)")=4.187"Specific Heat capacity";
Real m3dot_dash(unit = "kg/h")" mass flowarte of concentrate";
Real mv_dot(unit = "kg/h")" mass flowarte of vapour";
Real dT(unit="K")"Temperature gradient";
Real bpr2(unit = "K")"Boiling point Rise";
Real bpr3(unit = "K")"Boiling point Rise";
Real sum_bpr(unit = "K");
Real dT_1(unit="K")"Temperature gradient";
Real Hf(unit = "kJ/kg")"Enthalpy of feed ";
Real H1(unit = "kJ/kg")"Enthalpy";
Real H2(unit = "kJ/kg")"Enthalpy";
Real H3(unit = "kJ/kg")"Enthalpy";
Real mv3_dot(unit = "kg/h")" mass flowarte of vapour";
Real mv1_dot(unit = "kg/h")"mass flowarte of vapour";
Real mv2_dot(unit = "kg/h")"mass flowarte of vapour";
Real ms_dot(unit = "kg/h")"mass flowarte of steam";
Real A1(unit = "sq m")"Area of first effect";
Real A2(unit = "sq m")"Area of second effect";
Real A3(unit = "sq m")"Area of third effect";
Real eco"Steam economy";
Real Qc(unit = "kJ/h")"Heat removed from vapour";
Real mw_dot(unit = "kJ/h")"mass flowarate of liquid";
equation
//Overall glycerine balance
m3dot_dash=(ic/fc)*mf_dot;          
mv_dot=mf_dot-m3dot_dash;   
mv_dot =  mv1_dot+mv2_dot+mv3_dot;   
dT=Ts-Tv3;      
bpr2=bpr1;
bpr3=bpr2;
sum_bpr=bpr1+bpr2+bpr3;      
dT_1=dT-sum_bpr;               
//Enthalpies of various streams
Hf=Cpf*(Tf-T);   //Wrong value considered in book of Tf.        
H1=Cpf*(393.5-T);          
H2=Cpf*(367.5-T);          
H3=Cpf*(338-T);           
//MATERIAL AND ENERGY BALANCES
//First effect
//Material balance
//m1dot_dash=mf_dot-mv1_dot                                       
//Equation(1)
//m1dot_dash=1750+mv2_dot+mv3_dot;                                 
//Equation(2)           
//Energy balance
//ms_dot*lambda_s+mf_Dot*hf=mv1_dot*Hv1+m1dot_dash*H1             Equation(3) 
2160*ms_dot+2238*(mv2_dot+mv3_dot)=19800500;
//Equation(4) 
//Second effect
//m1dot_dash=mv2_dot+m2dot_dash;                                  Equation(5) 
//Energy balance:
//m1dot_dash*H1+mv1_dot*lambda_v1=mv2_dot*Hv2+m2dot_dash*H2       Equation(6)
//Substituting for m1dot_dash from Equation(2) and m2dot_dash from Equation(5) and with the numerical values for the quantities Equation(6) becomes,
4425.1*mv2_dot+2130.4*mv3_dot=18554800;                          
//Equation(7)
//Equation(7) gives a relation between mv2_dot and mv3_dot as under,
//mv3_dot=8709.54-2.076*mv2_dot                                   Equation(8)
//Third effect:
//m2dot_dash=mv3_dot+m3dot_dash                                   Equation(9)
//m2dot_dash=mv3_dot+1750                                         Equation(10)
//Energy Balance
//m2dot_dash*H2+mv2_dot*lambda_v2=mv3_dot*Hv3+m3dot_dash*H3;     
(mv3_dot+1750)*356.1+mv2_dot*2297.4=mv3_dot*2600.5+1750*244.92;          
//Heat transfer Area is
A1=ms_dot*lambda_s*1000/(3600*U1*dT1);     
A2=mv1_dot*lambda_v1*1000/(3600*U2*dT2);   
A3=mv2_dot*lambda_v2*1000/(3600*U3*dT3);  
//The deviaiton is within +-10%
//Hence maximum A1 area can be recommended
eco=(mv_dot/ms_dot);     
Qc=mv3_dot*lambda_v3;      
mw_dot=Qc/(Cp*dT_W);
//Value of Hf is wrong hence ans. varies.
end Ex6_12;
