model Ex6_6
parameter Real mf_dot(unit = "kg/h")=5000"Mass flowarte of solution";
parameter Real ic=0.01"Initial concentration";
parameter Real fc=0.02"Final concentration  ";
parameter Real T(unit = "K")=373"Boiling pt of saturation";
parameter Real Ts(unit = "K")=383"Saturation temperature of steam   ";
parameter Real Hf(unit = "kJ/kg")=125.79"enthalpy of feed";
parameter Real Hdash(unit = "kJ/kg")=419.04"enthalpy of product";
parameter Real Hv(unit = "kJ/kg")=2676.1"enthalpy of vapour";
parameter Real lambda_s(unit = "kJ/kg")=2230.2"latent heat of condensing steam";
parameter Real A(unit = "sq m")=69"Heating area of evaporator ";
Real mdash_dot(unit = "kg/h")"Mass flow rate of thick liquor ";
Real mv_dot(unit = "kg/h")"Water evaporated";
Real ms_dot(unit = "kg/h")"Steam flow rate";
Real eco"Economy of evaporator";
Real Q(unit = "W")"Rate of heat transfer ";
Real dT(unit = "K") "Temperature gradient";
Real U(unit = "W/sq m.K")"Overall heat transfer coefficient";
equation
mdash_dot=ic*mf_dot/fc;   
mv_dot=mf_dot-mdash_dot;      
ms_dot=(mdash_dot*Hdash+mv_dot*Hv-mf_dot*Hf)/lambda_s;   
eco=mv_dot/ms_dot;           
Q=ms_dot*lambda_s*1000/3600;             
dT=Ts-T;                   
U=Q/(A*dT);      
end Ex6_6;
