model Ex2_11
import Modelica.Constants.*;
parameter Real d1(unit="mm")=300"O.D. of pipe";  
parameter Real x1(unit="m")=0.05"thickness ";  
parameter Real x2(unit="m")=0.04"thickness";  
parameter Real k1(unit="W/(m.K)")=0.105"Thermal conductivity";
parameter Real k2(unit="W/(m.K)")=0.07"Thermal conductivity";  
parameter Real L(unit="m")=1"length";  
parameter Real T1(unit="K")=623"Temperature of insulation";  
parameter Real T2(unit="K")=323"Temperature of insulation";  
parameter Real sR(unit="m")=0.871+0.827"";
Real r1(unit="m")"Radius of pipe";
Real r2(unit="m")"Radius of 1st layer  of insulation";
Real r3(unit="m")"Radius of 2nd layer of insulation";
Real rm1(unit="m")"Log mean radius";
Real rm2(unit="m")"Log mean radius";
Real A1(unit="sq.m")"Area of 1 st layer ";
Real R1(unit="K/W")"Thermal Resistance of 1 st layer  ";
Real A2(unit="sq.m")"Area of 2 nd  layer ";
Real R2(unit="K/W")"Thermal Resistance of 1 2nd  layer";
Real dT(unit="K")"Temperature difference";
Real Q_by_L(unit="W/m")"Heat loss";
Real P(unit="m")"Permiter of outer insulation";
Real Q_by_L_peri(unit="W/sq.m");
Real dT1(unit="K")"Temperature difference" ;
Real dT2(unit="K")"Temperature of surface between the two layers of insulation" ;
equation
r1=(d1/2)/1000; 
r2=r1+0.05; 
r3=r2+0.04; 
rm1=(r2-r1)/log(r2/r1);  
rm2=(r3-r2)/log(r3/r2);    
A1=pi*rm1*L;   
R1=x1/(k1*A1);
A2=pi*rm2*L;
R2=x2/(k2*A2);
dT=T1-T2;  
Q_by_L=dT/(R1+R2);   
P=2*pi*(r1+x1+x2);  
Q_by_L_peri=Q_by_L/P; 
dT1=dT*R1/sR;
dT2=T1-dT1;
end Ex2_11;
