model Ex2_12
parameter Real x1(unit="m")=0.01"Thicness of steel plate";  
parameter Real x2(unit="m")=0.15"Thicness of silica  brick";  
parameter Real x3(unit="m")=0.15"Thicness of magnesite  brick"; 
parameter Real T1(unit="K")=973"Temperature on inside edge of wall";  
parameter Real T2(unit="K")=423"Temperature on outside  edge of wall";  
parameter Real k1(unit="W/m.K")=16.86"Thermal conductivity of steel brick ";  
parameter Real k2(unit="W/m.K")=1.75"Thermal conductivity of silica brick";  
parameter Real k3(unit="W/m.K")=5.23"Thermal conductivity of magnesite brick";  
parameter Real k_air(unit="W/m.K")=0.0337"Thermal conductivity of air";  
parameter Real A(unit="sq m")=1"Area";  
Real dT(unit="K")"Temperature difference";
Real sigma_R(unit="K/W")"Thermal Resistance";
Real Q(unit="W/sq.m")"Heat flow";
Real Tm(unit="K")"Temperature drop in magnesite brick";
Real iT(unit="K")"Interface temperature between steel and magnesite brick";
Real sigma_xbyk;
Real x_by_k(unit="k/W")"Thermal Resistance Gradient ";
Real t(unit="mm")"Air gap thickness";
equation
dT=T1-T2;
sigma_R=(x1/(k1*A)+x2/(k2*A)+x3/(k3*A));
Q=dT/sigma_R; 
Tm=Q*x3/k3;  
iT=T2+Tm;  
sigma_xbyk= A*dT/1163;   //with air gap for reducing heat loss to 1163 per sq m
x_by_k=sigma_xbyk-sigma_R;   //x/k for air
t=x_by_k*k_air*1000;
end Ex2_12;
