model Ex2_2
import Modelica.Constants.*;
parameter Real L(unit="m")=1"Length of pipe"; 
parameter Real r1(unit="mm")=(50/2)/1000"Inner Radius of pipe";
parameter Real r2(unit="m")=(25+3)/1000"Outer Radius of pipe";
parameter Real k1(unit="W/(m.K)")=45"Thermal conductivity of pipe";
parameter Real k2(unit="W/(m.K)")=0.08"Thermal conductivity of inner lagging";
parameter Real ri1(unit="m")=0.028"Outer radius of pipe";
parameter Real k3(unit="W/(m.K)")=0.04"Thermal conductivity of outer lagging";
parameter Real ro1(unit="m")=0.053"outer radius for inner lagging";
parameter Real Ti(unit="K")=550"Temperature inside the pipe";
parameter Real To(unit="K")=330"Outside surface temperature";
Real rm1(unit="m")"Log mean radius";
Real R1(unit="K/W")"Resistance of pipe";
Real ri2(unit="m")"Outer radius of inner lagging";
Real rmi1(unit="m")"Log mean radius for inner lagging ";
Real R2(unit="K/W")"Thermal Resistance ";
Real ro2(unit="m")"Outer radius of outer lagging";
Real rmo1(unit="m")"Log mean radius  outer  lagging ";
Real R3(unit="K/W")"Thermal Resistance outer  lagging ";
Real R(unit="K/W")"Combined Thermal Resistance ";
Real dT(unit="K")"Temperature difference";
Real Q(unit="W/m")"Rate of heat loss";
equation
rm1=(r2-r1)/log(r2/r1);
R1=(r2-r1)/(k1*(2*pi*rm1*L)); // 
ri2=(ri1+r1); 
rmi1=(ri2-ri1)/log(ri2/ri1);
R2=(ri2-ri1)/(k2*2*pi*rmi1*L);
ro2=(ro1+0.04); 
rmo1=(ro2-ro1)/log(ro2/ro1);
R3=(ro2-ro1)/(k3*2*pi*rmo1*L);
R=R1+R2+R3;
dT=Ti-To; 
Q=dT/R;
end Ex2_2;
