model Ex2_25
import Modelica.Constants.*;
parameter Real h(unit = "W/sq m.K")=8.5"Heat transfer coefficient";
parameter Real T1(unit = "K")=480"Outer Temperature";
parameter Real T2(unit = "K")=305"Air Temperature";
parameter Real d0(unit = "m")=33.4/1000"OD of pipe";
parameter Real k(unit = "W/m.K")=0.07"Thermal conductivity For insulating material   ";
parameter Real RH(unit="%")=50"Reduction in heat loss";
Real Q_by_l(unit = "W/m")"rate of heat transfer ";
Real Q_by_l1(unit = "W/m")"Heat loss for insulated pipe";
Real r2(unit = "m")"Outer radius of pipe";
Real r3(unit = "m")"Radius of insulation";
Real dT(unit = "K")"Temperature gradient";
Real rT(unit = "m")"Required thickness of insulation";
equation
r2=d0/2;
dT=T1-T2;
Q_by_l=h*2*pi*r2*dT;        
//for insulated pipe--50% reduction in heat loss
Q_by_l1=(RH/100)*Q_by_l;     
Q_by_l1=dT/(((log(r3/r2))/(2*pi*k))+(1/(2*pi*r3*h)));
//by trial and error method we get:
rT=r3-r2;
end Ex2_25;
