model Ex2_4
parameter Real A(unit="sq.m")=1"Heat transfer area";   
parameter Real x1(unit="m")=229/1000"thickness of fire brick";    
parameter Real x2(unit="m")=115/1000"thickness of insulating brick";   
parameter Real x3(unit="m")=229/1000"thickness of building brick in";   
parameter Real k1(unit="W/(m.K")=6.05"thermal conductivity of fir brick";  
parameter Real k2(unit="W/m.K")=0.581"thermal conductivity of insulating brick";  
parameter Real k3(unit="W/m.K")=2.33"thermal conductivity of building brick";  
parameter Real T1(unit="K")=1223"inside temperature";   
parameter Real T2(unit="K")=323"Outside temperature";  
Real dT(unit="K")"Temperature difference";
Real R1(unit="K/W")"Thermal resistance of fire break";
Real R2(unit="K/W")"Thermal resistance of insulating brick ";
Real R3(unit="K/W")"Thermal resistance of building brick ";
Real Q(unit="W/m")"Rate of heat loss";
Real Ta(unit="K")"Temperature at interface between fire break and insulating break";
Real Tb(unit="K")"Temerature at interface between insulating brick and building brick";
equation
dT=T1-T2;  
R1=(x1/k1*A); 
R2=(x2/k2*A);  
R3=(x3/k3*A); 
Q=dT/(R1+R2+R3); 
Q=(T1-Ta)/R1;
Q=(Tb-T2)/R3;
end Ex2_4;
