model Ex2_44
import Modelica.Constants.*;
parameter Real rho(unit = "kg/cubic m")=8000"Density";
parameter Real Cp(unit="J/(kg*K")=420"Cp for thermocouple";
parameter Real h_hot(unit = "W/sq m.K")=60"convective coeff for hot stream ";
parameter Real dia(unit = "mm")=4"Dia. of sphere";
parameter Real t(unit="sec")=10"Time";
parameter Real T_inf(unit = "K")=573"Temperature of hot air";
parameter Real T0(unit = "K")=313"Temperature of junction";
parameter Real h_air(unit = "W/sq m.K")=10"convective coeff for air ";
parameter Real t_air(unit = "s")=20"Time";
parameter Real T_inf_air(unit = "K")=303"Temperature of air";
Real r(unit = "m")"radius";
Real V(unit = "cubic m")"Volume ";
Real A(unit = "sq m")"Surface area";
Real tao(unit = "seconds")"Time constant";
Real ratio"Ratio of thermocouple difference to initial temperature difference";
Real T(unit = "K")"Required temperature ";
Real tao_air(unit = "seconds")"Time constant";
Real ratio_air"Ratio of thermocouple difference to initial temperature difference";
Real T0_air(unit="K")"Temperature";
Real T_air(unit="K")"Temperature attained by junction 20 s after removing from the hot air stream";
equation
r=dia/(2*1000);    
V=(4/3)*pi*r^3;  
A=4*pi*r^2;      
tao=rho*Cp*V/(h_hot*A);    
ratio=2.72^(-t/tao);    
T=T_inf+ratio*(T0-T_inf);
tao_air=rho*Cp*V/(h_air*A);   
ratio_air=2.72^(-t_air/tao_air);
T0_air=T;
T_air=T_inf_air+ratio_air*(T0_air-T_inf_air);
end Ex2_44;
