package Ex2_7
  model Ex2_7_a
    parameter Real A(unit = "sq m") = 1 "Area of wall";
    parameter Real x1(unit = "m") = 114 / 1000 "thickness of layer of Sil-o-cel brick";
    parameter Real k1(unit = "W/(m.K)") = 0.138 "Thermal conductivity of Sil-o-cel brick";
    parameter Real x2(unit = "mm") = 229 / 1000 " thickness layer of common brick";
    parameter Real k2(unit = "W/m.K") = 1.38 "Thermal conductivity of Common brick";
    parameter Real dT(unit = "K") = 1033 - 349 "Temperature Difference";
    Real R1(unit="K/W")"Thermal Resistance of Sil-o-cel brick ";
    Real R2(unit="K/W")"Thermal Resistance of common brick ";
   Real Q(unit="W")"Rate of heat loss";
  equation
    R1 = x1 / (k1 * A);
    R2 = x2 / (k2 * A);
    Q = dT / (R1 + R2);
  end Ex2_7_a;







  model Ex2_7_b
  parameter Real A(unit="sq m")=1"Area of wall"; 
  parameter Real x1(unit="m")=114/1000"layer of Sil-o-cel brik"; 
  parameter Real k1(unit="W/(m.K)")=0.138"Thermal conductivity of Sil-o-cel brik"; 
  parameter Real x2(unit="mm")=229/1000"layer of common brik"; 
  parameter Real k2(unit="W/m.K")=1.38"Thermal conductivity of Common brik"; 
  parameter Real dT(unit="K")=1033-349"Temperature Difference";
  parameter Real cr(unit="K/W")=0.09"Contact resistance";
  Real R1(unit="K/W")"Thermal Resistance of Sil-o-cel brick ";
  Real R2(unit="K/W")"Thermal Resistance of common brick ";
  Real Q(unit="W")"Rate of heat loss";
  Real R(unit="K/W")"Combined Resistance";
  equation
  R1=x1/(k1*A);
  R2=x2/(k2*A);
  R=R1+R2+cr;
  Q=dT/R;
  end Ex2_7_b;





end Ex2_7;
