model Ex2_9
parameter Real ID(unit="mm")=50"Inner Diameter of sphere"; 
parameter Real dT(unit="K")=(573-303)"Temperature Difference";
parameter Real k(unit="W/(m.K)")=17.45"Thermal conductivity of sphere"; 
parameter Real OD(unit="mm")=150"Outer Diameter of sphere";
Real r1(unit="m")"ID of sphere";
Real r2(unit="m")"OD of sphere";
Real A1(unit="sq.m")"Area of sphere";
Real A2(unit="sq.m")"Area of sphere";
Real A(unit="sq.m")"Area of sphere";
Real Q(unit="W")"Heat Loss";
equation
r1=(ID/2)/1000;
r2=(OD/2)/1000;
A1=4*22/7*(r1^2);
A2=4*22/7*(r2^2);
A=sqrt(A1*A2);
Q=(A*k*dT)/(r2-r1);
//Answer in book varies slightly due to approximation
end Ex2_9;
