package Ex3_10
  model Ex3_10_a
  parameter Real v(unit="sq m./s")=16.96*10^(-6)"Viscosity";   
  parameter Real rho(unit="kg/cubic m")=1.128"Density";    
  parameter Real Npr=0.699"Prandtl number";
  parameter Real k(unit="W/m.K")=0.0276"Thermal Conductivity";    
  parameter Real u_inf(unit="m/s")=15"viscosity";
  parameter Real L(unit="m")=0.2"Length";    
  parameter Real Tw(unit="K")=293"Temperature";
  parameter Real T_inf(unit="K")=333"Temperature";
  Real Nre_l"Reynold's no";
  Real Nnu"Nusselt no";
  Real h(unit="W/(sq.m.K)")"Average value of Convective heat transfer co-efficient";
  Real A(unit="sq m")"Area of plate";
  Real Q(unit="W")"Rate of heat flow from both sides of plate";
  equation
  Nre_l=L*u_inf/v;    //Reynold's number
  //Since this is less than 3*10^5,the boundary layer is laminar over entire length
  Nnu=0.664*sqrt(Nre_l)*(Npr^(1.0/3.0));
  h=Nnu*k/L;    
  A=L^2;    
  Q=2*h*A*(T_inf-Tw);    
  end Ex3_10_a;



  model Ex3_10_b
  parameter Real v(unit="sq m./s")=16.96*10^(-6)"Viscosity";   
  parameter Real rho(unit="kg/cubic m")=1.128"Density";    
  parameter Real Npr=0.699"Prandtl number";
  parameter Real k(unit="W/m.K")=0.0276"Thermal Conductivity";    
  parameter Real u_inf(unit="m/s")=15"viscosity";
  parameter Real L(unit="m")=0.2"Length";    
  parameter Real Tw(unit="K")=293"Temperature";
  parameter Real T_inf(unit="K")=333"Temperature";
  Real Nre_l"Reynold's no";
  Real A(unit="sq m")"Area of plate";
  Real h(unit="W/(sq.m.K)")"Average value of Convective heat transfer co-efficient";
  Real Q(unit="W")"Rate of heat flow from both sides of plate";
  equation
  Nre_l=L*u_inf/v;    //Reynold's number;    
  A=L^2;      
  //ii-With turbulent boundary layer from the leading edge:
  h=k*0.0366*(Nre_l^(0.8))*(Npr^(1.0/3.0))/L;      
  //Heat transfer from both sides is :
  Q=2*h*A*(T_inf-Tw);  
  end Ex3_10_b;





end Ex3_10;
