model Ex3_15 
import Modelica.Constants.*;   
parameter Real u_inf(unit="m/s")=50"velocity";    
parameter Real mu(unit="kg/(m.s)")=2.14*10^(-5)"Viscocity";   
parameter Real rho(unit="kg/cubic m")=0.966"density";    
parameter Real k(unit="W/(m.K)")=0.0312"Thermal conbductivity";  
parameter Real Npr=0.695"Prandtl number";    
parameter Real D(unit="m")=0.05"Diameter";    
parameter Real Tw(unit="K")=423"surface Temperature  of cylinder";   
parameter Real T_inf(unit="K")=308"Temperature of Air";   
Real Nre"Reynold's no";
Real Nnu"Nusselt no";
Real h(unit="W/s m.K")"Heat transfer coeffficient";
Real Q_by_l(unit = "W")"Heat loss per unit length";
equation
Nre=D*u_inf*rho/mu ;  
Nnu=0.0266*Nre^0.805*Npr^(1/3);
h=Nnu*k/D   ; //W/sq m.K
//Heat loss per unit length is :
Q_by_l=h*pi*D*(Tw-T_inf);  //[W]
//Ans varies due to approximation in book
end Ex3_15;
