model Ex3_17
import Modelica.Constants.*;
parameter Real mu(unit="N.s/sq m")=0.8"Viscosity of flowing fluid"; 
parameter Real rho(unit="kg/cubic m")=1.1*1000"Density of flowinf fluid";    
parameter Real Cp(unit="J/kg.K")=1.26*10^3"Specific heat";    
parameter Real k(unit="W/(m.K)")=0.384"Thermal conductivity";    
parameter Real mu_w(unit="N.s/sq m")=1"Viscosity at wall temperature";    
parameter Real L(unit="m")=5"Length";   
parameter Real vfr(unit="cubic m/s")=300*10^(-6)"Volumetric flow rate";    
parameter Real Di(unit="m")=20/1000"Inside diameter";    
Real Area(unit="sq. m")"Area of pipe";
Real u(unit="m/s")"Velocity of fluid";
Real Nre"reynold's number";
Real Npr"Prandtl number";
Real Nnu"Nusselt numnber";
Real hi(unit="W/sq.m.K")"Heat Trnsfer Co-efficient";
equation  
Area=(pi/4)*Di^2;    
u=vfr/Area;   
Nre=Di*u*rho/mu;    
//As reynold's number is less than 2100,he flow is laminar
Npr=Cp*mu/k;    
Nnu=1.86*(Nre*Npr*Di/L)^(1.0/3.0)*(mu/mu_w)^(0.14);
hi=Nnu*k/Di;   
//Ans in book is wrong
end Ex3_17;
