  model Ex3_18
import Modelica.Constants.*;
parameter Real m(unit="kg/s")=5500/3600"Mass flow rate";    
parameter Real rho(unit="kg/m^3")=1.07*1000"Density of fluid";   
parameter Real Di(unit="m")=40/1000"Diameter";    
parameter Real mu(unit="kg/m.s")=0.004"Viscosity";    
parameter Real Cp(unit="J/kg.K")=2.72*10^3"Specific heat";    
parameter Real k(unit="W/m.K")=0.256"thermal conductivity";    
Real vfr(unit="cubic m/s")"Volumetric flow rate";    
Real A(unit="sq. m")"Area of pipe";
Real u(unit="m/s")"Velocity of fluid";
Real Nre"Reynold number";
Real Npr"Prandtl number";
Real Nnu"Nusselt number";
Real hi(unit="W/sq.m.K")"Heat Trnsfer Co-efficient";
equation
vfr=m/rho;    
A=(pi/4)*Di^2;   
u=vfr/A;    
Nre=Di*u*rho/mu;
Npr=Cp*mu/k;    
Nnu=0.023*(Nre^0.8)*(Npr^0.4);    
hi=k*Nnu/Di;    
//Calculation in book is wrong from Nre due to approximation in book..
end Ex3_18;
