model Ex3_25
import Modelica.Constants.*;
parameter Real mo_dot(unit = "kg/s")=6*10^(-2)"Mass flow rate of oil ";
parameter Real Cpo(unit = "kJ/(kg.K)")=2.0"Specific heat of oil ";
parameter Real T1(unit = "K")=420"Outlet temperature of oil";
parameter Real T2(unit = "K")=320"Inlet temperature of oil";
parameter Real t1(unit = "K")=290"Inlet temperature of water";
parameter Real Cpw(unit = "kJ/(kg.K)")=4.18"Specific heat capacity of water ";
parameter Real ho(unit = "kW/(sq m.K)")=1.6"Oil side heat transfer coefficient ";
parameter Real hi(unit = "kW/(sq m.K)")=3.6"Water side heat transfer coeff ";
parameter Real Do(unit = "m")=25/1000"O.D of pipe";
Real Q(unit = "kJ/s")"Rate of heat flow ";
Real mw_dot(unit="kg/s")"Mass flow rate of water";
Real t2(unit = "K")"Outlet temperature of water ";
Real dT1(unit = "K")"Temperature gradient";
Real dT2(unit = "K")"Temperature gradient";
Real dTm(unit = "K")"Log mean temperature";
Real U(unit = "kW/(m^2.K)")"Overall heat transfer coefficient";
Real A(unit = "sq m")"Area";
Real L(unit = "m")"Length of tube ";
equation
Q=mo_dot*Cpo*(T1-T2);   
mw_dot=mo_dot;   
//For finding outlet temperature of water
t2=t1+Q/(mw_dot*Cpw);  
dT1=T1-t2;   
dT2=T2-t1;   
dTm=(dT1-dT2)/log(dT1/dT2);  
//Overall heat transfer coefficient is:
U=1/(1/ho+1/hi); 
A=Q/(U*dTm);
L=A/(pi*Do);    
end Ex3_25;
