model Ex3_35
import Modelica.Constants.*;
parameter Real v(unit = "m^2/s")=2*10^(-5)"Kinematic diffusivity";
parameter Real Npr=0.7"Prandtl number";
parameter Real k(unit = "W/m.K")=0.03"Thermal conductivity";
parameter Real D(unit = "m")=0.25"Diameter";
parameter Real T1(unit = "K")=298"Atmospheric Temerature";
parameter Real T2(unit = "K")=403"Surface Temperature";
parameter Real g(unit = "m/s^2")=9.81"Acceleration due to  gravity";
Real L(unit = "m")"Characteristic length";
Real dT(unit = "K")"Temperature gradient";
Real Tf(unit = "K")"Film Temperature";
Real Beta(unit = "K^-1")"Volume expansion coefficient";
Real A(unit = "sq m")"Area";
Real Ngr"Grashof number";
Real Nnu"Nusselt number";
Real h(unit = "W/sqm.K")"Heat transfer co-efficient";
Real Q(unit = "W")"Rate of heat transfer";
Real Nnu1"Nusselt number";
Real h1(unit = "W/sqm.K")"Heat transfer co-efficient";
Real Q1(unit = "W")"Rate of heat transfer";
equation
L=0.90*D;   
dT=T2-T1;    
Tf=(T1+T2)/2;  
Beta=1/Tf;   
A=pi*(D/2)^2;  
//Case 1: Hot surface facing up
Ngr=g*Beta*dT*(L^3)/(v^2);  
Nnu=0.15*(Ngr*Npr)^(1.0/3.0);   
h=Nnu*k/L;  
Q=h*A*dT;   
//Case 2:For hot surface facing down
Nnu1=0.27*(Ngr*Npr)^(1.0/4.0);  
h1=Nnu1*k/L;  
Q1=h1*A*dT;   
//Ans in book for case 1 is wrong
end Ex3_35;
