model Ex3_36
parameter Real rho(unit = "kg/m^3")=960"Density";
parameter Real Beta(unit = "K^-1")=0.75*10^(-3)"Volume expansion coefficient";
parameter Real k(unit = "W/m.K")=0.68"Thermal conductivity";
parameter Real alpha(unit = "m^2/s")=1.68*10^(-7)"Thermal Diffusivity";
parameter Real v(unit = "m^2/s")=2.94*10^(-7)"Kinematic viscocity";
parameter Real Cp(unit = "kJ/kg.K")=4.216"Specific heat capacity";
parameter Real Tw(unit = "K")=403"Temperature of hot plate ";
parameter Real T_inf(unit = "K")=343"Temperature water ";
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to  gravity";
parameter Real l(unit = "m")=0.8"Length";
parameter Real W(unit = "m")=0.08"Width";
parameter Real P(unit = "m")=2*(0.8+0.08)"Perimeter ";
Real dT(unit = "K")"Temperature gradient";
Real A(unit = "m^2")"Area ";
Real L(unit = "m")"Characteristic dimension/length";
Real Nra"rayleigh number";
Real Nnu "Nusselt number";
Real ht(unit = "W/sq m.K") "Average heat transfer coefficient for upper surface of plate";
Real Nnu1 "Nusselt number";
Real hb(unit = "W/(m^2.K)")"Average heat transfer coefficient for lower surface of plate";
Real Q(unit = "W")"Heat transfer";
equation
dT=Tw-T_inf;     
A=l*W;   
L=A/P;   
Nra=g*Beta*L^3*dT/(v*alpha); 
//(i) for natural convection,heat transfer from top/upper surface heated 
Nnu=0.15*(Nra^(1/3));   
ht=Nnu*k/L;  
//(ii)For the bottom/lower surface of the heated plate
Nnu1=0.27*(Nra^(1.0/4.0));    
hb=Nnu1*k/L;  
//Rate of heat input is equal to rate of heat dissipation from the upper and lower surfaces of the plate
Q=(ht+hb)*A*(Tw-T_inf);  
//Ans in book varies due to slight approximation
end Ex3_36;
