model Ex3_39
import Modelica.Constants.*;
parameter Real k(unit = "W/(m.K)")=0.035"Thermal conductivity";
parameter Real Npr=0.684"Prandtl number";
parameter Real Beta(unit = "K^-1")=2.42*10^(-3)"Volume expansion coefficient";
parameter Real v(unit = "m^2/s")=27.8*10^(-6)"Kinematic viscocity";
parameter Real Tw(unit = "K")=533"Temperature of ball";
parameter Real T_inf(unit = "K")=363"Temperature of air";
parameter Real D(unit = "m")=0.01"Diameter";
parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to  gravity";
Real dT(unit = "K")"Temperature gradient";
Real Nra"rayleigh number";
Real A(unit = "m^2")"Area of sphere ";
Real Nnu "Nusselt number";
Real h(unit = "W/sq m.K") "Average heat transfer coefficient";
Real Q(unit = "W")"rate of heat  loss ";
equation
dT=Tw-T_inf; 
Nra=(g*Beta*dT*(D^3))/(v^2);
A=4*pi*(D/2)^2; 
Nnu=(2+0.43*Nra^(1.0/4.0));
h=Nnu*k/D;  
Q=h*A*dT;    
end Ex3_39;
