model Ex3_40
parameter Real v(unit = "m^2/s")=17.95*10^(-6)"Kinematic viscocity";
parameter Real dT(unit = "K")=353-293"Temperature gradient";
parameter Real k(unit = "W/m.K")=0.0283"Thermal conductivity";
parameter Real g(unit = "m/s^2")=9.81"Acceleration due to  gravity";
parameter Real Npr=0.698"Prandtl number";
parameter Real Cp(unit = "J/(kg.K)")=1005"Specific Heat capacity";
parameter Real Tf(unit = "K")=323"Film temperature";
parameter Real l(unit = "m")=1"length";
parameter Real A(unit = "m^2")=1*1"Area ";
parameter Real P(unit = "m")=4*l"Perimeter ";
Real Beta(unit = "K^-1")"Volume expansion coefficient";
Real Nra"rayleigh number";
Real Nnu"Nusselt number";
Real h(unit = "W/m^2.K")"Average heat transfer coefficient ";
Real Q1(unit = "W")"Heat loss";
Real L(unit = "m")"Characterstic length";
Real Nra1"rayleigh number";
Real Nnu1"Nusselt number";
Real h1(unit = "W/m^2.K")"Average heat transfer coefficient ";
Real Q2(unit = "W")"Heat loss";
Real Q_total(unit = "W")"Total heat loss";
equation
Beta=1/Tf;   
Nra=(g*Beta*dT*(l^3)*Npr)/(v^2);
Nnu=0.59*((Nra)^(1/4));  
h=Nnu*k/l;  
//Heat loss form 4 vertical faces of 1m*1m is 
Q1=4*(h*A*dT);  
//For top surface 
L=A/P;   
Nra1=(Npr*g*Beta*dT*(L^3))/(v^2);
Nnu1=0.15*((Nra1)^(1/3));  
h1=Nnu1*k/L;   
Q2=h1*A*dT;   
Q_total=Q1+Q2;   
// results for all variables doesn't match with the textbook as Nra Value in book is wrong.

end Ex3_40;
