model Ex3_48
parameter Real rho(unit = "kh/m^3")=960"Density";
parameter Real mu(unit = "kg/(m.s)")=2.82*10^(-4)"viscocity";
parameter Real k(unit = "W/(m.K)")=0.68"thermal conductivity";
parameter Real lambda(unit = "J/kg")=2255*10^3"Latent heat-enthaply of vaporisation";
parameter Real Ts(unit = "K")=373"Saturation temperature of steam ";
parameter Real Tw(unit = "K")=371"Temperature of plate";
parameter Real L(unit = "m")=0.3"Dimension ";
parameter Real g(unit = "m/s^2")=9.81"Acceleration due to  gravity";
Real dT(unit = "K")"Temperature gradient";
Real h(unit = "W/sq m.K")"Convective heat transfer coeff";
Real A(unit = "sq m")"Area ";
Real Q(unit = "W")"Heat Transfer rate";
Real m_dot(unit = "kg/h")"Condensate rate";
equation
dT=Ts-Tw;    
h=0.943*(rho^2*g*lambda*k^3/(L*mu*dT))^(1/4);    
A=L^2;   
Q=h*A*(Ts-Tw);  
m_dot=(Q/lambda)*3600;  
end Ex3_48;
