model Ex3_50
import Modelica.Constants.*;
parameter Real rho(unit = "kg/m^3")=960"Density";
parameter Real k(unit = "W/m.K")=0.68"thermal conductivity";
parameter Real mu(unit = "kg/(m.s)")=282*10^(-6)"viscocity";
parameter Real Tw(unit = "K")=371"Tube wall temperature ";
parameter Real Ts(unit = "K")=373"Saturation temperature";
parameter Real lambda(unit = "J/kg")=2256.9*10^3"Latent heat-enthaply of vaporisation";
parameter Real Do(unit = "m")=0.0125"OD";
parameter Real g(unit = "m/s^2")=9.81"Acceleration due to  gravity";
parameter Real n=10"Number of tubes";
parameter Real L(unit = "m")=1"length";
parameter Real n1(unit="m")=100"Number of tubes";
Real dT(unit = "K")"Temperature gradient";
Real h(unit = "W/sq m.K")"Convective heat transfer coeff";
Real A(unit = "sq m")"Area ";
Real Q(unit = "W")"Heat Transfer rate";
Real ms_dot(unit = "kg/h")"Condensation rate";
equation
dT=Ts-Tw;    
h=0.725*(((rho^2)*g*lambda*(k^3)/(mu*n*Do*dT))^(1.0/4.0)); 
A=n1*pi*Do*L;    
Q=h*A*dT;    
ms_dot=(Q/lambda)*3600; 
//results for all variables doesn't match with the textbook.
end Ex3_50;
