model Ex3_51
import Modelica.Constants.*;
parameter Real rho(unit = "kg/m^3")=975"Density";
parameter Real k(unit = "W/m.K")=0.871"thermal conductivity";
parameter Real dT(unit = "K")=10"Temperature gradient";
parameter Real mu(unit = "N.s/m^2")=380.5*10^(-6)"viscocity";
parameter Real lambda(unit = "J/kg")=2300*1000" Latent heat of condensation ";
parameter Real Do(unit = "m")=100/1000"Outer diameter";
parameter Real g(unit = "m/s^2")=9.81"Acceleration due to  gravity";
Real L(unit="m")"Length";
Real h(unit = "W/(sq m.K)")"Convective heat transfer coeff";
Real A(unit = "sq m")"Area ";
Real Q(unit = "W")"Heat Transfer rate";
Real mc_dot(unit = "kg/h")"Condensation rate";
equation
0.725/(Do)^(1/4)=0.943/(L)^(1/4);
h=0.943*(((rho^2)*lambda*g*(k^3))/(mu*L*dT))^(1/4);  
A=pi*Do*L;  
Q=h*A*dT;    
mc_dot=(Q/lambda)*3600;  
//Ans varies due to approximation
end Ex3_51;
