model Ex3_9
parameter Real v(unit="sq m./s")=17.36*10^(-6)"Viscosity for air ";   
parameter Real k(unit="W/(m.K)")=0.0275"Thermal Conductivity";   
parameter Real Cp(unit="kJ/(kg.K")=1.006"Specific heat capacity";
parameter Real Npr=0.7"Prandlt number for air";   
parameter Real u_inf(unit="m/s")=2"viscosity";    
parameter Real x(unit="m")=0.2"Length";    
parameter Real w(unit="m")=1"width";   
parameter Real Tw(unit="K")=333"Temperature";    
parameter Real T_inf(unit="K")=300"Temperature";    
Real Nre_x"Reynold's no";
Real Nnu_x"Nusselt no";
Real hx(unit="W/(sq.m.K)")"Convective heat transfer co-efficient";
Real h(unit="W/(sq.m.K)")"Average value of Convective heat transfer co-efficient";
Real A(unit="sq m")"Area of plate";
Real Q(unit="W")"Rate of heat flow";
Real Q1(unit="W")"Rate of heat flow from both sides of plate ";
equation
Nre_x=u_inf*x/v;    //Reynolds number at x=0.2    m
//Since this is less than 3*10^5
Nnu_x=0.332*sqrt(Nre_x)*(Npr^(1.0/3.0));
hx=Nnu_x*k/x;    
//Average value of heat transfer coeff is twice this value
h=2*hx;    
A=x*w;     
Q=h*A*(Tw-T_inf);    
Q1=2*Q;    
// Ans Varies slightly due to approximation in book
end Ex3_9;
