model Ex4_10
import Modelica.Constants.*;
parameter Real e1=0.05"Emissivity of inner sphere ";
parameter Real e2=0.05"Emissivity of outer sphere ";
parameter Real D1(unit="cm")=30"Diameter of inner sphere";
parameter Real D2(unit="cm")=36"Diameter of outer sphere";
parameter Real T1(unit = "K")=293"Temperature of outer sphere";
parameter Real T2(unit = "K")=90"Temperature of oxygen";
parameter Real sigma(unit = "W/m^2.K^4")=5.67*10^(-8)"stefan Boltzman Constant";
parameter Real lambda(unit = "kJ/kg")=21.44"Latent heat";
Real A1_A2"ratio";
Real F12"Interchange factor";
Real Q_by_A(unit = "W/sq m")"Heat loss";
Real Q(unit = "kJ/h")"Heat loss";
Real m_dot(unit="kg/h")"Amount of oxygen evoprated";
equation
A1_A2=(D1/D2)^2;
F12=1/(1/e1+(A1_A2)*(1/e2-1));
Q_by_A=sigma*F12*(T1^4-T2^4);    
Q=Q_by_A*pi*((D1/100)^2)*3600/1000; 
m_dot=Q/lambda;    
end Ex4_10;
