model Ex4_12
import Modelica.Constants.*;
parameter Real sigma(unit = "W/sq m.K^4")=5.67*10^(-8)"stefan Boltzman Constant";
parameter Real T1(unit = "K")=77"Liquid Nitrogen Temperature";
parameter Real T2(unit = "K")=303"Temperature of Sphere";
parameter Real D1(unit = "m")=32/100"Diameter of Sphere";
parameter Real D2(unit = "m")=36/100"Diameter of Shell";
parameter Real e1(unit="m")=0.03"Emissivity ";
parameter Real e2(unit="m")=0.03"Emissivity  ";
parameter Real lambda(unit = "kJ/kg")=201"Latent heat";
Real A1(unit = "sq m")"Area of sphere";
Real A2(unit = "sq m")"Area of shell";
Real Q(unit = "kJ/h")"Rate of Heat transfer";
Real m_dot(unit = "kg/h")"Evaporation rate";
equation
A1=pi*D1^2; 
A2=pi*D2^2; 
Q=abs(sigma*A1*(T1^4-T2^4)/(1/e1+(A1/A2)*(1/e2-1))*3600/1000);   
m_dot=Q/lambda; 
//Ans varies due to approximation in book.
end Ex4_12;
