model Ex4_13
import Modelica.Constants.*;
parameter Real D1(unit = "mm")=250/1000"Diameter of inner sphere";   
parameter Real D2(unit = "m")=350/1000"Diameter of outer sphere";
parameter Real sigma(unit = "W/sq m.K^4")=5.67*10^(-8)"stefan Boltzman Constant";
parameter Real T1(unit = "K")=76"Temperature of Air";
parameter Real T2(unit = "K")=300"Ambient Temperature";
parameter Real e1=0.04"Emissivity of inner sphere ";
parameter Real e2=0.04"Emissivity of outer sphere ";
parameter Real lambda(unit = "kJ/kg")=200"Latent heat";
Real A1(unit = "sq m")"Area of inner sphere ";
Real A2(unit = "sq m")"Area of outer sphere ";
Real Q(unit = "kJ/h")"Rate of heat flow";
Real Rate(unit = "kg/h")"Rate of Evaporation";
equation
A1=pi*D1^2; 
A2=pi*D2^2; 
Q=abs((sigma*A1*(T1^4-T2^4)/((1/e1)+(A1/A2)*((1/e2)-1)))*3600/1000);  
Rate=Q/lambda;  
end Ex4_13;
