model Ex4_20
parameter Real sigma(unit = "W/(sq m.K^4)")=5.67*10^(-8)"stefan Boltzman Constant";
parameter Real T1(unit = "K")=750"Temperature of plate 1";
parameter Real T2(unit = "K")=500"Temperature of plate 2";
parameter Real e1=0.75"Emissivity of plate 1";
parameter Real e2=0.5"Emissivity of plate 2";
parameter Real e3=0.05"Emissivity of shield";
parameter Real F13=1"Shape factor";
parameter Real F32=1"Shape factor";
Real Q_by_a(unit = "W/sq m")"Heat transfer without shield";
Real R1"Resistance 1";
Real R2"Resistance 2";
Real R3"Resistance 3";
Real R4"Resistance 4";
Real R5"Resistance 5";
Real R6"Resistance 6";
Real Total_R"Total resistance";
Real Q_by_as(unit = "W/sq m")"Heat transfer with shield";
Real Red(unit="%")"Reduciton in heat tranfer due to shield";
equation
//Heat transfer without shield :
Q_by_a=sigma*(T1^4-T2^4)/((1/e1)+(1/e2)-1); 
//Heat transfer with shield:
R1=(1-e1)/e1;    
R2=1/F13;        
R3=(1-e3)/e3;    
R4=(1-e3)/e3;    
R5=1/F32;        
R6=(1-e2)/e2;      
Total_R=R1+R2+R3+R4+R5+R6;   
Q_by_as=sigma*(T1^4-T2^4)/Total_R;   
Red=(Q_by_a-Q_by_as)*100/Q_by_a;    
end Ex4_20;
