model Ex4_22
parameter Real sigma(unit = "W/(sq m.K^4)")=5.67*10^(-8)"stefan Boltzman Constant";
parameter Real T1(unit = "K")=1273"Temperature of plate 1";
parameter Real T2(unit = "K")=773"Temperature of plate 2";
parameter Real T3(unit = "K")=300"Temperature of wall";
parameter Real A1(unit = "sq m")=0.5"Area of plate 1";
parameter Real A2(unit = "sq m")=0.5"Area of plate 2";
parameter Real F12=0.285"Shape factor";
parameter Real F21=0.285"Shape factor";
parameter Real e1=0.2"Emissivity of plate 1";
parameter Real e2=0.5"Emissivity of plate 2";
parameter Real R6=0"Given (1-e3)/e3*A3=0";
Real F13"Shape factor";
Real F23"Shape factor";
Real R1"Resistance 1";
Real R2"Resistance 2";
Real R3"Resistance 3";
Real R4"Resistance 4";
Real R5"Resistance 5";
Real Eb1(unit="W/sq m")"Emissive power";
Real Eb2(unit = "W/sq m")"Emissive power";
Real Eb3(unit = "W/sq m")"Emissive power";
Real J1(unit = "W/sq m")"Radiosity`";
Real J2(unit = "W/sqm")"Radiosity";
Real J3(unit = "W/sq m")"Radiosity";
Real Q1(unit = "W/sq m")"Heat lost by plate 1";
Real Q2(unit = "W/sq m")"Heat lost by plate 2";
Real Q3(unit = "W/sq m")"Heat lost by plate 3";
equation
F13=1-F12;
F23=1-F21;
//Resistance in the network are calculated as:
R1=(1-e1)/(e1*A1);
R2=(1-e2)/(e2*A2);
R3=1/(A1*F12);
R4=1/(A1*F13);
R5=1/(A2*F23);
//Also
Eb1=sigma*T1^4; 
Eb2=sigma*T2^4;   
Eb3=sigma*T3^4; 
(Eb1-J1)/8+(J2-J1)/7.018+(Eb3-J1)/2.797=0;
(J1-J2)/7.018+(Eb3-J2)/2.797+(Eb2-J2)/2=0;
J3=Eb3; 
Q1=(Eb1-J1)/((1-e1)/(e1*A1));        
Q2=(Eb2-J2)/((1-e2)/(e2*A2));        
Q3=(J1-J3)/(1/(A1*F13))+(J2-J3)/(1/(A2*F23));   
//Ans varies due to approximation in book.
end Ex4_22;
